import { Component, OnInit, Inject } from '@angular/core';
import { NgRedux, select } from 'ng2-redux';
import { Http, Response, Headers, RequestOptions } from '@angular/http';
import { IAppState } from './store';
import { 
  INIT,
  SET_ENVIRONMENT,
  FETCH_BOOKMARKS
} from './actions';

import { BookmarkServices } from './services/bookmark-services';
import { SideNavigationService } from './services/side-navigation-service';
import { ApiServices } from './services/api-services';
import { SystemServices } from './services/system-services';
import { TemplatingServices } from './services/templating-services';

@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.scss']
})
export class AppComponent implements OnInit {
  @select(['bookmark', 'bookmarks']) bookmarks;
  constructor(
    private templatingServices: TemplatingServices,
    private bookmarkServices: BookmarkServices,
    private snService: SideNavigationService,
    private ngRedux: NgRedux<IAppState>,
    private apiServices: ApiServices,
    private systemServices: SystemServices) {
    ngRedux.dispatch({
      type: INIT
    });
    this.templatingServices = templatingServices;
  }

  async ngOnInit() {
    let data = await this.apiServices.getEnvironment();
    let jsonData = JSON.parse(data);
    jsonData.production = !(jsonData.production === 'false');
    this.ngRedux.dispatch({
      type: SET_ENVIRONMENT,
      payload: jsonData
    });
    await this.systemServices.validateSSO();
  }

  getState() {
    return this.ngRedux.getState();
  }

  isActive(type) {
    return this.snService.isActive(type);
  }

  canExpand() {
    return this.snService.isExpanded();
  }

  canDisplayView() {
    return true;
  }

  canDisplayConceptCard() {
    return this.getState().conceptCard.canViewConceptCard;
  }

  canDisplayNodeView() {
    return this.getState().conceptNode.canViewNode;
  }

  canCardConceptExpand(options) {
    switch (options) {
      case 'horizontal':
        // if side tool is minimized return true
        if (!this.snService.isExpanded()) {
          return false;
        } else {
          return true;
        }
      case 'vertical':
        // if node view is minimized return true
        if (this.getState().conceptNode.canViewNode) {
          return false;
        } else {
          return true;
        }
      case null:
        // if everything is expanded return true
        if (this.getState().conceptCard.displayCard && this.getState().conceptNode.canViewNode) {
          return false;
        } else {
          return true;
        }
    }
  }

  canFooterExpand(options) {
    switch (options) {
      case 'horizontal':
        // if side tool is minimized return true
        if (!this.snService.isExpanded()) {
          return false;
        } else {
          return true;
        }
      case 'vertical':
        // if node view or conceptcard is minimized return true
        if (this.getState().conceptNode.canViewNode || this.getState().conceptCard.canViewConceptCard) {
          return false;
        } else {
          return true;
        }
    }
  }
  canConceptViewExpand(options) {
    switch (options) {
      case 'horizontal':
        // if side tool is minimized return true
        if (this.getState().conceptCard.displayCard) {
          return false;
        } else {
          return true;
        }
      case 'vertical':
        // if node view is minimized return true
        if (this.getState().conceptCard.canViewConceptCard) {
          return false;
        } else {
          return true;
        }
      case null:
        // if everything is expanded return true
        if (this.getState().conceptCard.displayCard && this.getState().conceptCard.canViewConceptCard) {
          return false;
        } else {
          return true;
        }
    }
  }

  authenticated() {
    return this.systemServices.isAuthenticated();
  }

}
